/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ias.cache.AggregateStatus;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.BitMap;
import oracle.ias.cache.CacheEvent;
import oracle.ias.cache.CacheEventListener;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheFullException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheHandleQ;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CantSynchronizeGroupException;
import oracle.ias.cache.Child;
import oracle.ias.cache.CleanLists;
import oracle.ias.cache.DiskCache;
import oracle.ias.cache.DiskCacheException;
import oracle.ias.cache.DiskMessage;
import oracle.ias.cache.Element;
import oracle.ias.cache.Flag;
import oracle.ias.cache.GroupInfo;
import oracle.ias.cache.GroupNameException;
import oracle.ias.cache.InvalidObjectException;
import oracle.ias.cache.InvalidOperationException;
import oracle.ias.cache.LoadConflictException;
import oracle.ias.cache.Mdslot;
import oracle.ias.cache.Message;
import oracle.ias.cache.Net;
import oracle.ias.cache.NotOwnerException;
import oracle.ias.cache.NullObjectNameException;
import oracle.ias.cache.ObjectExistsException;
import oracle.ias.cache.ObjectReq;
import oracle.ias.cache.ObjectStatus;
import oracle.ias.cache.OwnerInfo;
import oracle.ias.cache.RegionCount;
import oracle.ias.cache.RegionNotFoundException;
import oracle.ias.cache.Response;
import oracle.ias.cache.ResponseFailedException;
import oracle.ias.cache.SlotTree;
import oracle.ias.cache.Task;
import oracle.ias.cache.TimeElement;
import oracle.ias.cache.TimeoutException;
import oracle.ias.cache.group.Address;

final class Bucket {
    static final int ALLOCSIZE = 10;
    static final int CHILDLISTSIZE = 32;
    int bucknum;
    int refcount;
    SlotTree slotList = new SlotTree(10);
    BitMap zeroref = new BitMap();
    BitMap validslots = new BitMap();
    BitMap activeslots = new BitMap();
    BitMap intvl1;
    BitMap diskZeroref;
    BitMap diskValidslots;
    BitMap diskActiveslots;
    BitMap diskIntvl1;
    BitMap idleslots;
    int mapCapacity;
    DiskCache diskCache;
    DiskCache globalDiskCache;

    Bucket(int n) {
        this.activeslots.initMap(1);
        this.intvl1 = new BitMap();
        if (CacheInternal.globalDiskPath != null) {
            this.diskZeroref = new BitMap();
            this.diskValidslots = new BitMap();
            this.diskActiveslots = new BitMap();
            this.diskActiveslots.initMap(1);
            this.diskIntvl1 = new BitMap();
        }
        this.idleslots = new BitMap();
        this.mapCapacity = this.intvl1.getCapacity();
        this.refcount = 0;
        this.bucknum = n;
    }

    synchronized boolean isPresent(Object object, String string, int n, int n2) {
        Element element = this.slotList.findElement(n2, object, string, n, false);
        if (element == null) {
            return false;
        }
        Mdslot mdslot = element.slot;
        return !this.isExpired(mdslot);
    }

    synchronized int canDefine(Object object, String string, int n, int n2) {
        Element element = this.slotList.findElement(n2, object, string, n, false);
        if (element == null) {
            return 0;
        }
        Mdslot mdslot = element.slot;
        if (this.isExpired(mdslot)) {
            return 0;
        }
        if ((mdslot.state & 2L) != 0L) {
            return -1;
        }
        if ((mdslot.state & 0x300L) == 768L) {
            return 1;
        }
        return -1;
    }

    synchronized int getRegionNumber(String string, int n) {
        Element element = this.slotList.findElement(n, string, string, 0, false);
        if (element == null) {
            return 0;
        }
        Mdslot mdslot = element.slot;
        if (this.isExpired(mdslot)) {
            return 0;
        }
        return mdslot.regionNumber;
    }

    synchronized int getRegionCount(String string, int n) {
        Element element = this.slotList.findElement(n, string, string, 0, false);
        if (element == null) {
            return -1;
        }
        Mdslot mdslot = element.slot;
        if (mdslot.regionCount == null) {
            return -1;
        }
        int n2 = mdslot.regionCount.length;
        RegionCount regionCount = mdslot.regionCount[n2 - 1];
        return regionCount.count;
    }

    synchronized String getParent(String string, int n) throws RegionNotFoundException {
        Element element = this.slotList.findElement(n, string, string, 0, false);
        if (element == null) {
            throw new RegionNotFoundException(CacheInternal.EXP_NOREGION + ": \"" + string + "\"");
        }
        Mdslot mdslot = element.slot;
        if (this.isExpired(mdslot)) {
            throw new RegionNotFoundException(CacheInternal.EXP_NOREGION + ": \"" + string + "\"");
        }
        return mdslot.parent;
    }

    synchronized Mdslot findSlot(ObjectReq objectReq, int n, Flag flag) throws LoadConflictException, CacheFullException, ObjectExistsException, IOException, SecurityException, DiskCacheException, CacheException {
        Mdslot mdslot = null;
        boolean bl = (objectReq.type & 0x1000000L) != 0L;
        Element element = this.slotList.findElement(n, objectReq.name, objectReq.qualifier, objectReq.qualId, bl);
        flag.mask = 0L;
        if (element == null) {
            if ((objectReq.type & 0x40000L) != 0L) {
                return null;
            }
            element = this.slotList.getFreeElement();
            element.key = n;
            this.slotList.insertElement(element);
            if (element.slot == null) {
                element.slot = new Mdslot();
                element.slot.objid = CacheHandle.makeid(this.bucknum, element.elid);
                if (element.elid >= this.mapCapacity) {
                    this.growMaps();
                }
            }
            mdslot = element.slot;
            this.validslots.setBit(element.elid);
            mdslot.qualifier = objectReq.qualifier;
            mdslot.name = objectReq.name;
            mdslot.state = objectReq.type | 0x10L;
            if ((objectReq.type & 0x80L) != 0L && mdslot.aggStatus == null) {
                mdslot.aggStatus = new AggregateStatus();
            }
            mdslot.state &= 0xFFFFFFFFFFDFFDFFL;
            if ((objectReq.type & 0x1000L) == 4096L && CacheInternal.rootDiskPath != null) {
                DiskCache diskCache = CacheInternal.isDistributedObject(mdslot) ? this.globalDiskCache : this.diskCache;
                flag.mask = diskCache.checkDisk(mdslot);
                this.growDiskMaps(mdslot.mdRecNum);
            } else {
                flag.mask = 8L;
            }
        } else {
            if ((objectReq.type & 0x800000L) != 0L && !this.isExpired(element.slot) && !CacheInternal.NULL_OBJECT.equals(element.slot.object)) {
                String string = element.slot.name == null ? " " : " \"" + element.slot.name + "\"";
                throw new ObjectExistsException(CacheInternal.EXP_OBJEXISTS + string);
            }
            if ((objectReq.type & 0x8000L) != 0L && (element = this.update(objectReq, element)) == null) {
                return null;
            }
            mdslot = element.slot;
            if ((objectReq.type & 0x200000L) != 0L && (mdslot.state & 4L) != 0L) {
                throw new LoadConflictException(CacheInternal.EXP_LDCONFL);
            }
            if ((objectReq.type & 0x48000L) != 262144L) {
                flag.mask = (mdslot.state & 4L) == 4L ? 4L : ((mdslot.state & 2L) == 2L ? 2L : 8L);
            }
        }
        if ((flag.mask & 8L) != 0L) {
            mdslot.state |= 4L;
        }
        mdslot.objStatus.lastAccess = System.currentTimeMillis();
        this.zeroref.clearBit(element.elid);
        if ((mdslot.state & 0x100L) != 0L && CacheInternal.isDistributedObject(mdslot)) {
            this.diskZeroref.clearBit(mdslot.mdRecNum);
            this.diskActiveslots.clearBit(mdslot.mdRecNum);
        }
        ++mdslot.refcount;
        ++mdslot.objStatus.accessCount;
        if (mdslot.idleTime != 0L && mdslot.refcount == 1) {
            this.idleslots.clearBit(element.elid);
            if (mdslot.timeToLive >= System.currentTimeMillis()) {
                mdslot.timeToLive = 0L;
            }
        }
        ++this.refcount;
        return mdslot;
    }

    synchronized boolean checkObjectRef(DiskMessage diskMessage) throws CacheException {
        Element element = this.slotList.getElement(diskMessage.name, diskMessage.qualifier, diskMessage.instNum, diskMessage.mdId, diskMessage.fileName);
        return element != null && element.slot.refcount > 0;
    }

    synchronized void freeSlot(int n) {
        Element element = this.slotList.getElement(n);
        Mdslot mdslot = element.slot;
        if ((mdslot.state & 0x80L) != 0L && mdslot.userClassLoader != null) {
            CacheInternal.removeUserClassLoader(mdslot.qualifier);
        }
        if ((mdslot.state & 0x100L) != 0L && !CacheInternal.isDistributedObject(mdslot)) {
            try {
                long l = this.diskCache.freeSlot(mdslot.name, mdslot.fileName, mdslot.mdRecNum, mdslot.instNum);
                CacheInternal.updateLocalDiskSize(l, false);
                if (CacheInternal.isDistributed()) {
                    CacheInternal.updateGlobalDiskSize(l, false);
                }
            }
            catch (CacheException cacheException) {
                CacheInternal.exceptionLog("[Mem] ", cacheException);
            }
        }
        if ((mdslot.state & 0x40L) != 0L) {
            CacheInternal.decCurCnt(mdslot);
        }
        this.slotList.freeElement(n);
        this.validslots.clearBit(n);
        if ((mdslot.state & 0x100L) != 0L && CacheInternal.isDistributedObject(mdslot)) {
            this.diskValidslots.clearBit(mdslot.mdRecNum);
        }
    }

    synchronized long freeDiskSlot(Object object, String string, int n, int n2) throws CacheException {
        return this.globalDiskCache.freeSlot(object, string, n, n2);
    }

    synchronized void objInvalidate(int n, long l, boolean bl, boolean bl2) throws CacheException {
        Element element = this.slotList.getElement(n);
        Mdslot mdslot = element.slot;
        if (mdslot.objid != l) {
            if (!bl) {
                return;
            }
            throw new InvalidObjectException(CacheInternal.EXP_BADID);
        }
        if ((mdslot.state & 0x10L) != 0L) {
            if ((mdslot.state & 0x80L) == 0L || bl2) {
                CacheHandle cacheHandle;
                Object object;
                mdslot.state &= 0xFFFFFFFFFBFFFFEFL;
                this.slotList.removeElement(n);
                if ((mdslot.state & 0x100L) != 0L) {
                    object = CacheInternal.isDistributedObject(mdslot) ? this.globalDiskCache : this.diskCache;
                    object.invalidate(mdslot);
                }
                if (bl2 && mdslot.ownerInfo != null && mdslot == mdslot.ownerInfo.slot && (cacheHandle = mdslot.ownerInfo.lockHolder) != null) {
                    Hashtable hashtable = cacheHandle.lockTable;
                    if (hashtable != null) {
                        hashtable.put(mdslot.name, "000DESTROYED$$");
                    }
                    this.notifyAll();
                }
                this.validslots.clearBit(n);
                if ((mdslot.state & 0x100L) != 0L && CacheInternal.isDistributedObject(mdslot)) {
                    this.diskValidslots.clearBit(mdslot.mdRecNum);
                }
                if ((mdslot.state & 0x40L) != 0L && (object = mdslot.regionCount) != null) {
                    for (int i = 0; i < ((RegionCount[])object).length; ++i) {
                        object[i].dec(mdslot.objStatus.size);
                    }
                }
            } else if (mdslot.timeToLive != 0L) {
                mdslot.timeToLive = System.currentTimeMillis() + mdslot.ttlInterval * 1000L;
                TimeElement timeElement = new TimeElement(mdslot);
                CacheInternal.ttlQ.putTimeElement(timeElement);
            }
            this.setEvent(mdslot, 0);
            if ((mdslot.state & 0x200000000L) != 0L) {
                this.setEvent(mdslot, 4);
            } else if ((mdslot.state & 0x400000000L) != 0L) {
                this.setEvent(mdslot, 5);
            } else {
                this.setEvent(mdslot, 3);
            }
        }
        this.objRelease(n, l, bl);
    }

    synchronized GroupInfo objRelease(int n, long l, boolean bl) throws CacheException {
        GroupInfo groupInfo = null;
        Element element = this.slotList.getElement(n);
        Mdslot mdslot = element.slot;
        if (mdslot.objid != l) {
            if (!bl) {
                return null;
            }
            throw new CacheException(CacheInternal.EXP_BADID);
        }
        if (bl) {
            --mdslot.refcount;
            --this.refcount;
            if (mdslot.refcount < 0) {
                throw new CacheException(CacheInternal.EXP_NEGREFCNT + " " + mdslot.name + " " + mdslot.refcount);
            }
        }
        if (mdslot.refcount == 0) {
            if (mdslot.kidCount == 0) {
                this.zeroref.setBit(n);
                if ((mdslot.state & 0x100L) != 0L && CacheInternal.isDistributedObject(mdslot)) {
                    this.diskZeroref.setBit(mdslot.mdRecNum);
                }
                if ((mdslot.state & 0x10L) == 0L) {
                    if ((mdslot.state & 0x80L) != 0L && mdslot.groupId > 0L) {
                        groupInfo = new GroupInfo(mdslot.groupId, mdslot.mygId);
                    }
                    this.freeSlot(n);
                } else if (mdslot.idleTime != 0L && (mdslot.state & 0x80L) == 0L) {
                    this.idleslots.setBit(n);
                    mdslot.timeToLive = System.currentTimeMillis() + 1000L * mdslot.idleTime;
                }
            } else {
                mdslot.object = null;
            }
        }
        return groupInfo;
    }

    synchronized void setEvent(Mdslot mdslot, int n) {
        if (mdslot.eventHandlers == null || mdslot.eventHandlers[n] == null || (mdslot.state & 4L) != 0L || (mdslot.state & 0x80L) != 0L && mdslot.eventDefault[n]) {
            return;
        }
        if (CacheInternal.shouldLog(7)) {
            CacheInternal.logger.log("[Mem] set event=" + n + " slotname=" + mdslot.name + " state=" + Mdslot.getStateString(mdslot.state));
        }
        CacheEvent cacheEvent = mdslot.object == null ? new CacheEvent(n, mdslot.name, mdslot.qualifier, mdslot.name, mdslot.eventHandlers[n]) : new CacheEvent(n, mdslot.name, mdslot.qualifier, mdslot.object, mdslot.eventHandlers[n]);
        Task task = new Task(34, cacheEvent);
        CacheInternal.asyncTaskQ.putTask(task);
    }

    synchronized void objReleaseGroup(int n, GroupInfo groupInfo, long l) {
        Object var6_4 = null;
        Element element = this.slotList.getElement(n);
        Mdslot mdslot = element.slot;
        if (mdslot.objid != groupInfo.id || mdslot.children == null || mdslot.children[groupInfo.index].id == 0L) {
            return;
        }
        --mdslot.kidCount;
        mdslot.children[groupInfo.index].id = 0L;
        mdslot.children[groupInfo.index].slot = null;
        mdslot.childFreeMap.setBit(groupInfo.index);
    }

    synchronized Mdslot getSlot(int n, long l, boolean bl) throws InvalidObjectException {
        Element element = this.slotList.getElement(n);
        Mdslot mdslot = element.slot;
        if (mdslot.objid != l) {
            throw new InvalidObjectException(CacheInternal.EXP_BADID);
        }
        if (bl) {
            ++this.refcount;
            ++mdslot.refcount;
        }
        return mdslot;
    }

    private synchronized Element update(ObjectReq objectReq, Element element) throws IOException, CacheException {
        Mdslot mdslot = element.slot;
        if ((objectReq.type & 0x40000L) != 0L && (mdslot.state & 2L) == 0L) {
            return null;
        }
        if ((mdslot.state & 4L) != 0L) {
            return element;
        }
        if ((mdslot.state & 0x4000L) == 0L) {
            throw new InvalidOperationException(CacheInternal.EXP_INVALUPDATE + mdslot.name);
        }
        if ((objectReq.type & 0x200L) == 0L && (mdslot.state & 0x20000L) != 0L && mdslot.ownerInfo.lockHolder != objectReq.caller) {
            throw new NotOwnerException(CacheInternal.EXP_NOTOWNER + mdslot.name);
        }
        if ((objectReq.type & 0x200L) != 0L && (mdslot.state & 0x200L) == 0L) {
            return null;
        }
        objectReq.group = mdslot.group;
        mdslot.oldObjid = mdslot.objid;
        if (mdslot.refcount == 0 && (mdslot.state & 0x100L) == 0L) {
            RegionCount[] regionCountArray;
            mdslot.objid = CacheHandle.updateid(mdslot.objid);
            mdslot.object = objectReq.loadArgs;
            mdslot.state |= 0x8000L;
            mdslot.state &= 0xFFFFFFFFFFFFFFFDL;
            if ((mdslot.state & 0x80000000L) != 0L) {
                CacheInternal.decCurCnt(mdslot);
            }
            if ((mdslot.state & 0x40L) != 0L && (regionCountArray = mdslot.regionCount) != null) {
                for (int i = 0; i < regionCountArray.length; ++i) {
                    regionCountArray[i].dec(mdslot.objStatus.size);
                }
            }
            this.setEvent(mdslot, 1);
            return element;
        }
        Element element2 = this.slotList.getFreeElement();
        element2.key = element.key;
        if (element2.slot == null) {
            element2.slot = new Mdslot();
            element2.slot.objid = CacheHandle.makeid(this.bucknum, element2.elid);
            if (element2.elid >= this.mapCapacity) {
                this.growMaps();
            }
        }
        Mdslot mdslot2 = element2.slot;
        this.validslots.setBit(element2.elid);
        mdslot2.oldObjid = mdslot.objid;
        mdslot2.qualifier = mdslot.qualifier;
        mdslot2.parent = mdslot.parent;
        mdslot2.name = mdslot.name;
        mdslot2.group = mdslot.group;
        mdslot2.state = mdslot.state;
        mdslot2.mygId = mdslot.mygId;
        mdslot2.groupId = mdslot.groupId;
        mdslot2.object = objectReq.loadArgs;
        mdslot2.ownerInfo = mdslot.ownerInfo;
        mdslot2.idleTime = mdslot.idleTime;
        mdslot2.ttlInterval = mdslot.ttlInterval;
        mdslot2.regionNumber = mdslot.regionNumber;
        mdslot2.state |= 0x8000L;
        mdslot2.state &= 0xFFFFFFFFFFFFFEFDL;
        mdslot.objStatus.clone(mdslot2.objStatus);
        if (!CacheInternal.incrCurCnt(mdslot2)) {
            int n = CacheHandle.findSlot(mdslot.objid);
            this.objInvalidate(n, mdslot.objid, false, false);
            int n2 = CacheHandle.findSlot(mdslot2.objid);
            this.objInvalidate(n2, mdslot2.objid, false, false);
            throw new CacheFullException(CacheInternal.EXP_FULL);
        }
        if (mdslot.eventHandlers != null) {
            mdslot2.eventHandlers = new CacheEventListener[6];
            mdslot2.eventDefault = new boolean[6];
            for (int i = 0; i < 6; ++i) {
                mdslot2.eventHandlers[i] = mdslot.eventHandlers[i];
                mdslot2.eventDefault[i] = mdslot.eventDefault[i];
            }
        }
        mdslot.eventHandlers = null;
        if ((objectReq.type & 0x200L) == 0L && CacheInternal.isDistributedObject(mdslot) && (mdslot.state & 0x100L) != 0L) {
            CacheInternal.addInvalidation(mdslot, true);
        }
        int n = CacheHandle.findSlot(mdslot.objid);
        this.objInvalidate(n, mdslot.objid, false, false);
        this.slotList.findElement(element2.key, mdslot2.name, mdslot2.qualifier, mdslot2.regionNumber, false);
        this.slotList.insertElement(element2);
        if (mdslot2.ttlInterval > 0L && mdslot2.timeToLive == 0L) {
            mdslot2.timeToLive = System.currentTimeMillis() + mdslot2.ttlInterval * 1000L;
        }
        this.setEvent(mdslot2, 1);
        return element2;
    }

    synchronized void setGroup(int n, Mdslot mdslot) throws InvalidObjectException, CacheException {
        Mdslot mdslot2 = this.getSlot(n, mdslot.groupId, false);
        if (mdslot2.children[mdslot.mygId].id == mdslot.oldObjid && mdslot.oldObjid != 0L && (mdslot.state & 0x10L) != 0L) {
            mdslot2.children[mdslot.mygId].id = mdslot.objid;
            mdslot2.children[mdslot.mygId].slot = mdslot;
        } else if (mdslot2.children[mdslot.mygId].id != 0L) {
            --mdslot2.kidCount;
            mdslot2.children[mdslot.mygId].id = 0L;
            mdslot2.children[mdslot.mygId].slot = null;
            mdslot2.childFreeMap.setBit(mdslot.mygId);
            if ((mdslot.state & 0x10L) != 0L) {
                this.addChild(mdslot2, mdslot);
            }
        }
        mdslot.oldObjid = 0L;
    }

    synchronized int setRegionNumber(Mdslot mdslot, int n) throws RegionNotFoundException {
        if (!mdslot.name.equals(mdslot.qualifier)) {
            throw new RegionNotFoundException(CacheInternal.EXP_NOREGION);
        }
        if (mdslot.regionNumber == 0) {
            mdslot.regionNumber = n;
        }
        return mdslot.regionNumber;
    }

    synchronized void initFromDisk() throws DiskCacheException, NullObjectNameException {
        if (CacheInternal.globalDiskPath != null) {
            this.globalDiskCache = new DiskCache(CacheInternal.globalDiskPath, this.bucknum);
            this.globalDiskCache.loadFromDisk();
        }
        this.diskCache = new DiskCache(CacheInternal.diskPath, this.bucknum);
    }

    private void loadSlot(DiskCache diskCache, int n) throws DiskCacheException {
        this.slotList.findElement(n, diskCache.name, diskCache.qualifier, 0, false);
        Element element = this.slotList.getFreeElement();
        element.key = n;
        this.slotList.insertElement(element);
        if (element.slot == null) {
            element.slot = new Mdslot();
            element.slot.objid = CacheHandle.makeid(this.bucknum, element.elid);
            if (element.elid >= this.mapCapacity) {
                this.growMaps();
            }
        }
        Mdslot mdslot = element.slot;
        mdslot.qualifier = new String(diskCache.qualifier);
        mdslot.name = diskCache.name;
        mdslot.fileName = new String(diskCache.fileName);
        mdslot.path = new String(diskCache.path);
        mdslot.timeToLive = diskCache.timeToLive;
        mdslot.ttlInterval = diskCache.ttlInterval;
        mdslot.idleTime = diskCache.idleTime;
        mdslot.version = diskCache.version;
        mdslot.instNum = diskCache.instNum;
        mdslot.mdRecNum = diskCache.mdRecNum;
        mdslot.state = 0x8000000L;
        mdslot.objStatus.fileSize = diskCache.fileSize;
        this.validslots.setBit(element.elid);
        this.growDiskMaps(mdslot.mdRecNum);
        this.diskValidslots.setBit(mdslot.mdRecNum);
        if (diskCache.flags != 0L) {
            mdslot.state |= diskCache.flags;
        }
        if (diskCache.isLoading()) {
            mdslot.state |= 0x4000000L;
        }
        mdslot.state |= 0x110L | diskCache.storType;
        if (mdslot.timeToLive == 0L) {
            mdslot.state |= 0x400L;
        }
        if ((mdslot.state & 0x1000L) != 0L) {
            mdslot.object = mdslot.path + File.separator + mdslot.fileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOnDisk(Mdslot mdslot) {
        DiskCache diskCache = this.globalDiskCache;
        mdslot.fileName = new String(diskCache.fileName);
        mdslot.path = new String(diskCache.path);
        mdslot.instNum = diskCache.instNum;
        mdslot.mdRecNum = diskCache.mdRecNum;
        mdslot.state |= diskCache.storType;
        mdslot.objStatus.fileSize = diskCache.fileSize;
        if (diskCache.flags != 0L) {
            mdslot.state |= diskCache.flags;
        }
        Flag flag = mdslot.loadLock;
        synchronized (flag) {
            mdslot.state |= 0x100L;
            if (diskCache.isLoading()) {
                mdslot.state |= 0x4000000L;
            } else {
                mdslot.state &= 0xFFFFFFFFFBFFFFFFL;
                mdslot.loadLock.notifyAll();
            }
        }
    }

    synchronized long checkDiskSlot(Mdslot mdslot) throws DiskCacheException {
        long l = -1L;
        if ((mdslot.state & 0x10L) == 0L || mdslot.object != null && !(mdslot.object instanceof Serializable) || !(mdslot.name instanceof Serializable)) {
            return l;
        }
        DiskCache diskCache = CacheInternal.isDistributedObject(mdslot) ? this.globalDiskCache : this.diskCache;
        l = diskCache.checkDisk(mdslot);
        this.growDiskMaps(mdslot.mdRecNum);
        if (l == 4L) {
            mdslot.state |= 0x4000000L;
        }
        mdslot.state |= 0x100L;
        ++mdslot.refcount;
        return l;
    }

    synchronized void updateDiskSlot(Mdslot mdslot) throws DiskCacheException {
        DiskCache diskCache = CacheInternal.isDistributedObject(mdslot) ? this.globalDiskCache : this.diskCache;
        diskCache.updateSlot(mdslot);
        if (diskCache == this.diskCache) {
            CacheInternal.updateLocalDiskSize(mdslot.objStatus.fileSize, true);
        } else {
            this.diskValidslots.setBit(mdslot.mdRecNum);
        }
        if (CacheInternal.isDistributed()) {
            CacheInternal.updateGlobalDiskSize(mdslot.objStatus.fileSize, true);
        }
        --mdslot.refcount;
    }

    synchronized void updateSpooledSlot(Mdslot mdslot) throws CacheException {
        this.updateDiskSlot(mdslot);
        if (mdslot.refcount == 0) {
            if ((mdslot.state & 0x40L) != 0L) {
                CacheInternal.decCurCnt(mdslot);
            }
            mdslot.state &= 0xFFFFFFFFFFFFFFBDL;
            mdslot.object = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean getLock(Mdslot mdslot, OwnerInfo ownerInfo, CacheHandle cacheHandle, boolean bl, int n) throws InvalidObjectException, TimeoutException, ResponseFailedException {
        long l = 0L;
        if ((mdslot.state & 0x10L) == 0L) {
            throw new InvalidObjectException(CacheInternal.EXP_INVALOBJ);
        }
        if (ownerInfo.state == 3 || ownerInfo.state == 0 && bl) {
            ownerInfo.lockHolder = cacheHandle;
            ownerInfo.state = 1;
            return true;
        }
        if (ownerInfo.state == 1 && ownerInfo.lockHolder == cacheHandle) {
            return true;
        }
        if ((ownerInfo.state == 1 || ownerInfo.state == 2) && ownerInfo.lockHolder != cacheHandle) {
            ++ownerInfo.lockWaiters;
            l = System.currentTimeMillis();
            long l2 = l + (long)n;
            while (ownerInfo.lockHolder != null) {
                if (n <= 0) {
                    --ownerInfo.lockWaiters;
                    throw new TimeoutException();
                }
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    l = System.currentTimeMillis();
                    n = (int)(l2 - l);
                }
                if ((mdslot.state & 0x10L) != 0L) continue;
                --ownerInfo.lockWaiters;
                throw new InvalidObjectException(CacheInternal.EXP_INVALOBJ);
            }
            --ownerInfo.lockWaiters;
            if (ownerInfo.state == 0) {
                throw new ResponseFailedException(CacheInternal.EXP_RESPFAIL);
            }
            ownerInfo.lockHolder = cacheHandle;
            if (ownerInfo.state == 1) {
                return true;
            }
            ownerInfo.retry = true;
            return false;
        }
        ownerInfo.lockHolder = cacheHandle;
        ownerInfo.state = 2;
        return false;
    }

    synchronized void checkOwnershipResponse(OwnerInfo ownerInfo, Response response) {
        ownerInfo.retry = false;
        if (response.status == 1) {
            ownerInfo.state = 1;
            return;
        }
        ownerInfo.lockHolder = null;
        if (response.status != 7 || ownerInfo.lockWaiters == 0) {
            ownerInfo.state = 0;
        }
        if (ownerInfo.lockWaiters > 0) {
            this.notifyAll();
        }
    }

    synchronized int giveupOwnership(OwnerInfo ownerInfo, Task task) {
        if (ownerInfo.state == 3) {
            ownerInfo.state = 0;
            return 1;
        }
        if (ownerInfo.state == 1) {
            if (ownerInfo.remoteWaiter == null || ownerInfo.remoteWaiter.maxWaitTime < System.currentTimeMillis()) {
                ownerInfo.remoteWaiter = task;
                task.maxWaitTime += System.currentTimeMillis();
                return 3;
            }
            return 7;
        }
        if (ownerInfo.state == 2) {
            if (ownerInfo.lockHolder == null || ownerInfo.lockHolder.resp == null) {
                return 4;
            }
            if (ownerInfo.lockHolder.resp.replyReceived) {
                return 7;
            }
            ownerInfo.lockHolder.resp.setStatus(7);
        }
        return 4;
    }

    synchronized void releaseLock(OwnerInfo ownerInfo, CacheHandle cacheHandle) {
        if (ownerInfo == null) {
            return;
        }
        ownerInfo.lockHolder = null;
        if (ownerInfo.lockWaiters > 0 && ownerInfo.localCount < 8) {
            if (ownerInfo.remoteWaiter != null) {
                ++ownerInfo.localCount;
            }
            this.notifyAll();
            return;
        }
        if (ownerInfo.remoteWaiter != null) {
            if (ownerInfo.remoteWaiter.maxWaitTime > System.currentTimeMillis()) {
                Task task = ownerInfo.remoteWaiter;
                Message message = (Message)task.info;
                ownerInfo.state = 0;
                ownerInfo.localCount = 0;
                try {
                    Message message2 = new Message(message.name, message.qualifier, message.group, message.objectType, false);
                    message2.update(CacheInternal.cacheId, 1, false);
                    message2.messageId = message.messageId;
                    Task task2 = new Task(10, message2);
                    task2.replyAddr = task.replyAddr;
                    Net.memSend((Address)task.replyAddr, task2, null);
                    if (ownerInfo.lockWaiters > 0) {
                        ownerInfo.state = 2;
                        this.notifyAll();
                    }
                }
                catch (Exception exception) {
                    CacheInternal.exceptionLog("[Mem] ", exception);
                }
            } else {
                ownerInfo.state = 3;
            }
            ownerInfo.remoteWaiter = null;
        } else {
            ownerInfo.state = 3;
        }
    }

    synchronized void setAttributes(int n, long l, Attributes attributes) throws InvalidObjectException, CantSynchronizeGroupException, IOException {
        Object object;
        long l2 = 0L;
        long l3 = CacheInternal.setFlags(attributes);
        boolean bl = false;
        Mdslot mdslot = this.getSlot(n, l, false);
        if ((mdslot.state & 0x10L) == 0L || mdslot.objid != l) {
            throw new InvalidObjectException(CacheInternal.EXP_INVALOBJ);
        }
        if ((mdslot.state & 0x80L) == 0L) {
            if (attributes.ttl < 0L) {
                attributes.ttl = attributes.defaultTtl;
            }
            attributes.defaultTtl = -1L;
        }
        if ((mdslot.state & 0x80L) != 0L && (attributes.maxCount > 0 || attributes.maxSize > 0L)) {
            int n2;
            RegionCount[] regionCountArray;
            int n3 = 0;
            boolean bl2 = false;
            if (mdslot.regionCount != null) {
                n3 = mdslot.regionCount.length;
                regionCountArray = mdslot.regionCount;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (mdslot.objid != regionCountArray[n2].getId()) continue;
                    if (attributes.maxCount > 0) {
                        regionCountArray[n2].resetMax(attributes.maxCount);
                    }
                    if (attributes.maxSize > 0L) {
                        regionCountArray[n2].resetSize(attributes.maxSize);
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                object = new RegionCount(mdslot.objid, attributes.maxCount, attributes.maxSize);
                regionCountArray = new RegionCount[n3 + 1];
                for (n2 = 0; n2 < n3; ++n2) {
                    regionCountArray[n2] = mdslot.regionCount[n2];
                }
                regionCountArray[n3] = object;
                mdslot.regionCount = regionCountArray;
            }
        }
        if ((mdslot.state & 0x8000000L) == 0L) {
            if (attributes.ttl > 0L) {
                mdslot.timeToLive = l2 = System.currentTimeMillis() + attributes.ttl * 1000L;
            }
            if (attributes.versionSet) {
                mdslot.version = attributes.version;
            }
            mdslot.objStatus.priority = attributes.priority;
            mdslot.capacityPolicy = attributes.policy;
            if (attributes.userAttrs != null) {
                if (mdslot.userAttrs == null) {
                    mdslot.userAttrs = (Hashtable)attributes.userAttrs.clone();
                } else {
                    mdslot.userAttrs.putAll(attributes.userAttrs);
                }
            }
            if (mdslot.timeToLive > 0L && attributes.ttl == 0L) {
                bl = true;
                mdslot.timeToLive = 0L;
            }
            if (l2 == 0L && attributes.idleTime >= 0L) {
                mdslot.idleTime = attributes.idleTime;
            } else if (l2 > 0L) {
                mdslot.idleTime = 0L;
            }
            if (attributes.ttl >= 0L) {
                mdslot.ttlInterval = attributes.ttl;
            }
            if (attributes.defaultTtl >= 0L) {
                mdslot.ttlDefaultInterval = attributes.defaultTtl;
            }
        }
        if (l2 == 0L && mdslot.refcount == 0 && mdslot.idleTime != 0L && (mdslot.state & 0x80L) == 0L) {
            mdslot.timeToLive = System.currentTimeMillis() + 1000L * mdslot.idleTime;
            this.idleslots.setBit(n);
        }
        if (attributes.flagsSet) {
            mdslot.state &= 0xFFFFFFFF3FACD5FFL;
            mdslot.state |= l3 | 0x80000L;
        }
        if (attributes.handlers != null) {
            if (mdslot.eventHandlers == null) {
                mdslot.eventHandlers = new CacheEventListener[6];
                mdslot.eventDefault = new boolean[6];
            }
            for (int i = 0; i < 6; ++i) {
                if (!attributes.handlerSet[i]) continue;
                mdslot.eventHandlers[i] = attributes.handlers[i];
                mdslot.eventDefault[i] = attributes.handlerDefault[i];
            }
        }
        if ((mdslot.state & 0x80L) != 0L) {
            if (mdslot.timeToLive > 0L) {
                object = new TimeElement(mdslot);
                CacheInternal.ttlQ.putTimeElement((TimeElement)object);
            } else if (bl) {
                CacheInternal.ttlQ.removeElement(mdslot.objid);
            }
        }
        mdslot.objStatus.size = attributes.size;
    }

    synchronized void deccounts(Mdslot mdslot) {
        --this.refcount;
        --mdslot.refcount;
    }

    synchronized void inccounts(Mdslot mdslot) {
        ++this.refcount;
        ++mdslot.refcount;
        ++mdslot.objStatus.accessCount;
    }

    synchronized void addChild(Mdslot mdslot, Mdslot mdslot2) throws CacheException {
        int n;
        Child[] childArray;
        if (mdslot == mdslot2) {
            throw new GroupNameException(CacheInternal.EXP_GRPLOOP);
        }
        if (mdslot.children == null) {
            mdslot.kidCount = 0;
            childArray = mdslot.children = new Child[32];
            for (n = 0; n < 32; ++n) {
                childArray[n] = new Child();
            }
            mdslot.childFreeMap = new BitMap(32);
            mdslot.childFreeMap.initMap(1);
        } else {
            childArray = mdslot.children;
            int n2 = childArray.length;
            if (n2 == mdslot.kidCount) {
                int n3 = n2 + 32;
                Child[] childArray2 = new Child[n3];
                for (n = 0; n < n2; ++n) {
                    childArray2[n] = childArray[n];
                }
                for (n = n2; n < n3; ++n) {
                    childArray2[n] = new Child();
                }
                mdslot.children = childArray2;
                childArray = childArray2;
                childArray2 = null;
                mdslot.childFreeMap.growMap(n3, 1);
            }
        }
        int n4 = mdslot.childFreeMap.nextBit(0);
        mdslot.childFreeMap.clearBit(n4);
        childArray[n4].id = mdslot2.objid;
        childArray[n4].slot = mdslot2;
        ++mdslot.kidCount;
        if ((mdslot2.state & 0x10000000L) == 0L) {
            mdslot2.regionNumber = mdslot.regionNumber;
        } else {
            mdslot2.parent = mdslot.qualifier;
        }
        mdslot2.group = new String((String)mdslot.name);
        mdslot2.groupId = mdslot.objid;
        mdslot2.mygId = n4;
        mdslot2.capacityPolicy = mdslot.capacityPolicy;
        mdslot2.regionCount = mdslot.regionCount;
        if ((mdslot2.state & 0x80L) != 0L) {
            mdslot2.aggStatus.next = mdslot.aggStatus;
        }
        if ((mdslot2.state & 0x80000L) == 0L) {
            if ((mdslot2.state & 0x80L) != 0L) {
                mdslot2.ttlDefaultInterval = mdslot.ttlDefaultInterval;
                mdslot2.lockTable = mdslot.lockTable;
            } else {
                mdslot2.ttlInterval = mdslot.ttlDefaultInterval;
            }
            if ((mdslot2.state & 0x8000000L) == 0L) {
                mdslot2.version = mdslot.version;
            }
            mdslot2.idleTime = mdslot.idleTime;
            if (mdslot.userAttrs != null) {
                mdslot2.userAttrs = (Hashtable)mdslot.userAttrs.clone();
            }
            long l = System.currentTimeMillis();
            if ((mdslot2.state & 0x8000000L) == 0L && mdslot2.ttlInterval > 0L && (mdslot2.state & 0x1000000L) == 0L) {
                mdslot2.timeToLive = l + mdslot2.ttlInterval * 1000L;
            }
            long l2 = mdslot.state & 0xE0532A00L;
            mdslot2.state |= l2 | 0x80000L;
            mdslot2.loader = mdslot.loader;
            mdslot2.userClassLoader = mdslot.userClassLoader;
            if (mdslot2.userClassLoader != null) {
                CacheInternal.setUserClassLoader(mdslot2.qualifier, mdslot2.userClassLoader);
            }
            mdslot2.objStatus.priority = mdslot.objStatus.priority;
            mdslot2.objStatus.size = mdslot.objStatus.size;
            if (mdslot.ownerInfo != null) {
                mdslot2.ownerInfo = mdslot.ownerInfo;
            }
            if (mdslot.lockTable != null && (mdslot2.ownerInfo = (OwnerInfo)mdslot.lockTable.get(mdslot2.name)) == null) {
                mdslot2.ownerInfo = new OwnerInfo(mdslot.ownerInfo.slot);
                mdslot.lockTable.put(mdslot2.name, mdslot2.ownerInfo);
            }
            if (mdslot.eventHandlers != null) {
                mdslot2.eventHandlers = new CacheEventListener[6];
                mdslot2.eventDefault = new boolean[6];
                for (n = 0; n < 6; ++n) {
                    if (!mdslot.eventDefault[n]) continue;
                    mdslot2.eventHandlers[n] = mdslot.eventHandlers[n];
                    mdslot2.eventDefault[n] = true;
                }
            }
        }
    }

    synchronized RegionCount checkCapacity(Mdslot mdslot) {
        if (mdslot.regionCount == null) {
            return null;
        }
        RegionCount[] regionCountArray = mdslot.regionCount;
        for (int i = 0; i < regionCountArray.length; ++i) {
            if (mdslot.objid != regionCountArray[i].getId()) continue;
            if (regionCountArray[i].check()) {
                return regionCountArray[i];
            }
            return null;
        }
        return null;
    }

    synchronized long[] clearChildList(Mdslot mdslot, boolean bl) {
        Child[] childArray = mdslot.children;
        long[] lArray = new long[childArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = childArray[i].id;
            if (childArray[i].slot == null || !bl && (childArray[i].slot.state & 0x1000080L) != 0L) continue;
            childArray[i].id = 0L;
            childArray[i].slot = null;
            --mdslot.kidCount;
            mdslot.childFreeMap.setBit(i);
        }
        return lArray;
    }

    synchronized long[] getChildIdList(Mdslot mdslot) {
        long[] lArray = null;
        Child[] childArray = mdslot.children;
        lArray = childArray == null ? new long[]{} : new long[childArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = childArray[i].id;
        }
        return lArray;
    }

    synchronized CleanLists getChildList(Mdslot mdslot) {
        Mdslot[] mdslotArray = null;
        long[] lArray = null;
        Child[] childArray = mdslot.children;
        if (childArray == null) {
            mdslotArray = new Mdslot[]{};
            lArray = new long[]{};
        } else {
            mdslotArray = new Mdslot[childArray.length];
            lArray = new long[childArray.length];
        }
        for (int i = 0; i < mdslotArray.length; ++i) {
            mdslotArray[i] = childArray[i].slot;
            lArray[i] = childArray[i].id;
        }
        return new CleanLists(mdslotArray, lArray);
    }

    synchronized void cleanTtl() {
        int n = 0;
        long l = System.currentTimeMillis();
        while ((n = this.validslots.nextBit(n)) > 0) {
            this.checkTtl(n, l);
            ++n;
        }
    }

    synchronized void cleanIdle() {
        int n = 0;
        long l = System.currentTimeMillis();
        while ((n = this.idleslots.nextBit(n)) > 0) {
            this.checkTtl(n, l);
            ++n;
        }
    }

    synchronized void clean(long l, AggregateStatus aggregateStatus, int n, long l2) {
        int n2 = 0;
        long l3 = System.currentTimeMillis();
        while ((n > 0 || l2 > 0L) && (n2 = this.validslots.nextBit(n2)) > 0) {
            try {
                Element element = this.slotList.getElement(n2);
                Mdslot mdslot = element.slot;
                if (mdslot.refcount == 0 && (mdslot.state & 0x40L) != 0L && (mdslot.state & 0x80L) == 0L && (long)mdslot.objStatus.priority <= l && CacheInternal.capacityPolicy.policy(mdslot, aggregateStatus, l3)) {
                    if (CacheInternal.shouldLog(7)) {
                        CacheInternal.logger.log("[Mem] cleanup memory object " + mdslot.name);
                    }
                    if ((mdslot.state & 0x100L) != 0L) {
                        mdslot.state &= 0xFFFFFFFFFFFFFFFDL;
                        mdslot.state &= 0xFFFFFFFFFFFFFFBFL;
                        mdslot.object = null;
                        CacheInternal.decCurCnt(mdslot);
                        --n;
                    } else if (CacheInternal.rootDiskPath == null || (mdslot.state & 0x2000L) == 0L || !(mdslot.object instanceof Serializable)) {
                        if ((mdslot.state & 0x10000L) == 0L) {
                            mdslot.state &= 0xFFFFFFFFFFFFFFBFL;
                            CacheInternal.decCurCnt(mdslot);
                            this.slotList.removeElement(n2);
                            this.setEvent(mdslot, 5);
                            this.freeSlot(n2);
                            --n;
                        }
                    } else if ((mdslot.state & 0x100L) == 0L) {
                        this.spoolToDisk(mdslot);
                        --n;
                    }
                }
            }
            catch (CacheException cacheException) {
                CacheInternal.exceptionHandler(cacheException);
            }
            ++n2;
        }
    }

    synchronized void spoolToDisk(Mdslot mdslot) {
        Task task = new Task(5, (Object)mdslot, mdslot.objid);
        CacheInternal.asyncTaskQ.putTask(task);
        CacheInternal.decCurCnt(mdslot);
        if ((mdslot.state & 0x40L) != 0L) {
            RegionCount[] regionCountArray = mdslot.regionCount;
            if (regionCountArray != null) {
                for (int i = 0; i < regionCountArray.length; ++i) {
                    regionCountArray[i].dec(mdslot.objStatus.size);
                }
            }
            mdslot.state &= 0xFFFFFFFFFFFFFFBFL;
            CacheInternal.decCurCnt(mdslot);
        }
    }

    synchronized void clearBucket(boolean bl) {
        int n = 0;
        while ((n = this.validslots.nextBit(n)) > 0) {
            try {
                Element element = this.slotList.getElement(n);
                Mdslot mdslot = element.slot;
                if (CacheInternal.shouldLog(7)) {
                    CacheInternal.logger.log("[Mem] clearing object " + mdslot.name);
                }
                if (bl || (mdslot.state & 0x1000080L) == 0L) {
                    this.objInvalidate(n, mdslot.objid, false, bl);
                }
            }
            catch (CacheException cacheException) {
                CacheInternal.exceptionHandler(cacheException);
            }
            ++n;
        }
    }

    synchronized void cleanLocalDisk() {
        long l = 0L;
        int n = 0;
        try {
            BitMap bitMap = (BitMap)this.activeslots.clone();
            bitMap.andMap(this.intvl1);
            bitMap.andMap(this.validslots);
            bitMap.andMap(this.zeroref);
            while ((n = bitMap.nextBit(n)) >= 0) {
                Element element = this.slotList.getElement(n);
                Mdslot mdslot = element.slot;
                if ((mdslot.state & 0x100L) != 0L && !CacheInternal.isDistributedObject(mdslot)) {
                    if (CacheInternal.shouldLog(7)) {
                        CacheInternal.logger.log("[Mem] cleanLocalDisk freed " + mdslot.name);
                    }
                    int n2 = CacheHandle.findSlot(mdslot.objid);
                    mdslot.state |= 0x400000000L;
                    this.objInvalidate(n2, mdslot.objid, false, false);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Mem] ", exception);
        }
    }

    synchronized void cleanGlobalDisk() {
        BitMap bitMap = (BitMap)this.activeslots.clone();
        bitMap.andMap(this.intvl1);
        bitMap.andMap(this.validslots);
        bitMap.andMap(this.zeroref);
        if (bitMap.isZero()) {
            return;
        }
        try {
            Object object;
            int n;
            BitMap bitMap2 = this.getGlobalDiskMap();
            if (bitMap2.isZero()) {
                return;
            }
            CacheHandle cacheHandle = CacheHandleQ.getHandle();
            Message message = new Message("diskmap", null, null, this.bucknum, true);
            Task task = new Task(19, message);
            Net.broadcast(task, cacheHandle, 1);
            cacheHandle.resp.waitFor(10000);
            Vector vector = (Vector)cacheHandle.resp.retObj;
            if (vector != null) {
                for (n = 0; n < vector.size(); ++n) {
                    object = new BitMap((byte[])vector.elementAt(n));
                    bitMap2.andMap((BitMap)object);
                }
            }
            n = 0;
            while ((n = bitMap.nextBit(n)) >= 0) {
                object = this.slotList.getElement(n);
                Mdslot mdslot = ((Element)object).slot;
                if ((mdslot.state & 0x100L) != 0L && CacheInternal.isDistributedObject(mdslot) && bitMap2.testBit(mdslot.mdRecNum)) {
                    if (CacheInternal.shouldLog(7)) {
                        CacheInternal.logger.log("[Mem] cleanGlobalDisk freed " + mdslot.name);
                    }
                    CacheInternal.addInvalidation(mdslot, true);
                    message = new Message(mdslot.name, mdslot.qualifier, mdslot.group, 0L, false);
                    task = new Task(2, message);
                    Net.broadcast(task, cacheHandle, 1);
                    int n2 = CacheHandle.findSlot(mdslot.objid);
                    mdslot.state |= 0x400000000L;
                    this.objInvalidate(n2, mdslot.objid, false, false);
                }
                ++n;
            }
            CacheHandleQ.releaseHandle(cacheHandle);
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Mem] ", exception);
        }
    }

    synchronized BitMap getGlobalDiskMap() {
        BitMap bitMap = (BitMap)this.diskActiveslots.clone();
        bitMap.andMap(this.diskIntvl1);
        bitMap.andMap(this.diskValidslots);
        bitMap.andMap(this.diskZeroref);
        return bitMap;
    }

    synchronized void resetmaps() {
        this.intvl1 = (BitMap)this.activeslots.clone();
        this.activeslots.initMap(1);
        if (CacheInternal.globalDiskPath != null) {
            this.diskIntvl1 = (BitMap)this.diskActiveslots.clone();
            this.diskActiveslots.initMap(1);
        }
    }

    synchronized void updateDiskNotify() throws DiskCacheException {
        if (this.globalDiskCache != null) {
            this.globalDiskCache.checkForUpdates();
        }
    }

    synchronized void updateDisk() throws DiskCacheException, NullObjectNameException, IOException, CacheException {
        int n = CacheInternal.hashName(this.globalDiskCache.name);
        Element element = this.slotList.findElement(n, this.globalDiskCache.name, this.globalDiskCache.qualifier, 0, false);
        if (element == null) {
            if (this.globalDiskCache.isValid()) {
                this.loadSlot(this.globalDiskCache, n);
            }
        } else {
            Mdslot mdslot = element.slot;
            if ((mdslot.state & 0x4000004L) != 0L) {
                this.setOnDisk(mdslot);
            } else {
                mdslot.state &= 0xFFFFFFFFFFFFFEFFL;
                int n2 = CacheHandle.findSlot(mdslot.objid);
                this.objInvalidate(n2, mdslot.objid, false, false);
                if (this.globalDiskCache.isValid()) {
                    this.loadSlot(this.globalDiskCache, n);
                }
            }
        }
    }

    Mdslot getNext(int n, String string) {
        while ((n = this.validslots.nextBit(n)) >= 0) {
            Element element = this.slotList.getElement(n);
            Mdslot mdslot = element.slot;
            if (string == null) {
                return mdslot;
            }
            if (string.equals(mdslot.qualifier)) {
                return mdslot;
            }
            ++n;
        }
        return null;
    }

    private void checkTtl(int n, long l) {
        int n2 = 2;
        Element element = this.slotList.getElement(n);
        Mdslot mdslot = element.slot;
        if (mdslot.timeToLive != 0L && l >= mdslot.timeToLive) {
            if ((mdslot.state & 0x400080L) == 0x400080L) {
                n2 = 33;
            }
            mdslot.state |= 0x200000000L;
            Task task = new Task(n2, mdslot.name, mdslot.objid);
            CacheInternal.asyncTaskQ.putTask(task);
        }
    }

    void aggStats(int n) {
        int n2 = 0;
        while ((n2 = this.validslots.nextBit(n2)) > 0) {
            this.aggGroup(n2, n);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aggGroup(int n, int n2) {
        AggregateStatus aggregateStatus;
        Element element = this.slotList.getElement(n);
        Mdslot mdslot = element.slot;
        if ((mdslot.state & 0x80L) == 0L) {
            return;
        }
        Child[] childArray = mdslot.children;
        if (childArray == null) {
            AggregateStatus aggregateStatus2 = mdslot.aggStatus;
            aggregateStatus2.reset();
            aggregateStatus2.pass = n2;
            this.setParent(aggregateStatus2, n2);
            return;
        }
        AggregateStatus aggregateStatus3 = aggregateStatus = mdslot.aggStatus.getNewStats();
        synchronized (aggregateStatus3) {
            aggregateStatus.reset();
            aggregateStatus.pass = n2;
            for (int i = 0; i < childArray.length; ++i) {
                if (childArray[i].id == 0L || childArray[i].id != childArray[i].slot.objid) continue;
                if ((childArray[i].slot.state & 0x80L) != 0L) {
                    AggregateStatus aggregateStatus4 = childArray[i].slot.aggStatus;
                    if (aggregateStatus4.pass == n2) {
                        this.addStats(aggregateStatus4, aggregateStatus);
                        continue;
                    }
                    ++aggregateStatus.groupsToDo;
                    continue;
                }
                ObjectStatus objectStatus = childArray[i].slot.objStatus;
                ++aggregateStatus.objCount;
                this.setArr(objectStatus.priority, aggregateStatus.priority);
                this.setArr(objectStatus.accessCount, aggregateStatus.accessCount);
                this.setArr(objectStatus.size, aggregateStatus.size);
                this.setArr(objectStatus.lastAccess, aggregateStatus.lastAccess);
                this.setArr(objectStatus.loadTime, aggregateStatus.loadTime);
                this.setArr(objectStatus.createTime, aggregateStatus.createTime);
            }
            this.setAvg(aggregateStatus.objCount, aggregateStatus.priority);
            this.setAvg(aggregateStatus.objCount, aggregateStatus.accessCount);
            this.setAvg(aggregateStatus.objCount, aggregateStatus.size);
            this.setAvg(aggregateStatus.objCount, aggregateStatus.lastAccess);
            this.setAvg(aggregateStatus.objCount, aggregateStatus.loadTime);
            this.setAvg(aggregateStatus.objCount, aggregateStatus.createTime);
            if (aggregateStatus.groupsToDo == 0) {
                aggregateStatus.clone(mdslot.aggStatus);
                this.setParent(mdslot.aggStatus, n2);
            }
        }
    }

    private void setArr(long l, long[] lArray) {
        if (l < lArray[0]) {
            lArray[0] = l;
        }
        if (l > lArray[2]) {
            lArray[2] = l;
        }
        lArray[1] = lArray[1] + l;
    }

    private void setAvg(long l, long[] lArray) {
        lArray[1] = l == 0L ? 0L : lArray[1] / l;
    }

    private void addStats(AggregateStatus aggregateStatus, AggregateStatus aggregateStatus2) {
        int n = aggregateStatus.objCount;
        this.mergeArr(aggregateStatus.priority, aggregateStatus2.priority, n);
        this.mergeArr(aggregateStatus.accessCount, aggregateStatus2.accessCount, n);
        this.mergeArr(aggregateStatus.size, aggregateStatus2.size, n);
        this.mergeArr(aggregateStatus.lastAccess, aggregateStatus2.lastAccess, n);
        this.mergeArr(aggregateStatus.loadTime, aggregateStatus2.loadTime, n);
        this.mergeArr(aggregateStatus.createTime, aggregateStatus2.createTime, n);
        aggregateStatus2.objCount += aggregateStatus.objCount;
    }

    private void mergeStats(AggregateStatus aggregateStatus, AggregateStatus aggregateStatus2) {
        this.mergeArr(aggregateStatus.priority, aggregateStatus2.priority, aggregateStatus.objCount, aggregateStatus2.objCount);
        this.mergeArr(aggregateStatus.accessCount, aggregateStatus2.accessCount, aggregateStatus.objCount, aggregateStatus2.objCount);
        this.mergeArr(aggregateStatus.size, aggregateStatus2.size, aggregateStatus.objCount, aggregateStatus2.objCount);
        this.mergeArr(aggregateStatus.lastAccess, aggregateStatus2.lastAccess, aggregateStatus.objCount, aggregateStatus2.objCount);
        this.mergeArr(aggregateStatus.loadTime, aggregateStatus2.loadTime, aggregateStatus.objCount, aggregateStatus2.objCount);
        this.mergeArr(aggregateStatus.createTime, aggregateStatus2.createTime, aggregateStatus.objCount, aggregateStatus2.objCount);
        aggregateStatus2.objCount += aggregateStatus.objCount;
    }

    private void mergeArr(long[] lArray, long[] lArray2, int n) {
        if (lArray[0] < lArray2[0]) {
            lArray2[0] = lArray[0];
        }
        if (lArray[2] > lArray2[2]) {
            lArray2[2] = lArray[2];
        }
        lArray2[1] = lArray2[1] + lArray[1] * (long)n;
    }

    private void mergeArr(long[] lArray, long[] lArray2, int n, int n2) {
        if (lArray[0] < lArray2[0]) {
            lArray2[0] = lArray[0];
        }
        if (lArray[2] > lArray2[2]) {
            lArray2[2] = lArray[2];
        }
        long l = n2 + n == 0 ? 0L : (lArray2[1] * (long)n2 + lArray[1] * (long)n) / (long)(n2 + n);
        lArray2[1] = l;
    }

    private void setParent(AggregateStatus aggregateStatus, int n) {
        AggregateStatus aggregateStatus2 = aggregateStatus.next;
        if (aggregateStatus2 == null) {
            AggregateStatus aggregateStatus3 = CacheInternal.aggStatus.getNewStats();
            this.mergeStats(aggregateStatus, aggregateStatus3);
            return;
        }
        if (aggregateStatus2.newStats == null || aggregateStatus2.newStats.pass != n) {
            return;
        }
        AggregateStatus aggregateStatus4 = aggregateStatus2.newStats;
        this.mergeStats(aggregateStatus, aggregateStatus4);
        if (--aggregateStatus4.groupsToDo == 0) {
            aggregateStatus4.clone(aggregateStatus2);
            aggregateStatus4.reset();
            this.setParent(aggregateStatus2, n);
        }
    }

    private void growMaps() {
        int n = this.mapCapacity + 1;
        this.activeslots.growMap(n, 1);
        this.zeroref.growMap(n, 0);
        this.validslots.growMap(n, 0);
        this.intvl1.growMap(n, 0);
        this.idleslots.growMap(n, 0);
        this.mapCapacity = this.intvl1.getCapacity();
    }

    void growDiskMaps(int n) {
        if (CacheInternal.globalDiskPath == null) {
            return;
        }
        int n2 = this.diskIntvl1.getCapacity();
        if (n2 > n) {
            return;
        }
        int n3 = n + 1;
        this.diskActiveslots.growMap(n3, 1);
        this.diskZeroref.growMap(n3, 0);
        this.diskValidslots.growMap(n3, 0);
        this.diskIntvl1.growMap(n3, 0);
    }

    private boolean isExpired(Mdslot mdslot) {
        if (mdslot.timeToLive != 0L && System.currentTimeMillis() >= mdslot.timeToLive) {
            return (mdslot.state & 0x400080L) != 128L;
        }
        return false;
    }

    void dump() {
        this.slotList.dump(this.bucknum);
        if (this.globalDiskCache != null) {
            this.globalDiskCache.dump(this.bucknum);
        }
        if (this.diskCache != null) {
            this.diskCache.dump(this.bucknum);
        }
    }
}

